{HISTORY of Changes:
  ********* VERSION 1.04 *********
  18.01.1996 Property NAME of ISAMBROWSER changed form ISAMBROWSER1 to RECORDNAME+BROWSER1
  20.01.1996 Length of DBASE-FIELDNAMES = 8, search for fieldnames that already exist
  }

unit Wntisam4;
{$IFDEF VER90}
{$H-}
{$ENDIF}

interface

Uses Classes, DB, DBTables, Forms;
{$I DEFINE.PAS}
function Erzeuge_BrowserSource(const UnitIdent, FormIdent,
                               EditUnitIdent,EditFormIdent: String;
                               Parent: TForm;
                               Sprache: Integer;
                               TypDateiName, OrigPas: String): TMemoryStream;

function Erzeuge_EditorSource(const UnitIdent, FormIdent: String;
                              Parent: TForm;
                              Sprache: Integer;
                              TypDateiName, ProtoName,
                              OrigPas: String): TMemoryStream;

Function GetFieldTypEditor(S: String;
                           var FieldName: String;
                           var FieldDataType: TFieldType;
                           var Len: Integer;
                           var Arr1,Arr2: Integer;
                           var Decimals: Integer): Byte;

procedure FmtWrite(Stream: TStream; Fmt: PChar;
                   const Args: array of const);

implementation

Uses SysUtils, UToolDll, Dialogs, WntvBase, Wnt_Code,
     IsamExpt;

procedure FmtWrite(Stream: TStream; Fmt: PChar;
                   const Args: array of const);
begin
  if (Stream <> nil) and (SourceBuffer <> nil) then
  begin
    StrLFmt(SourceBuffer, SourceBufferSize, Fmt, Args);
    Stream.Write(SourceBuffer[0], StrLen(SourceBuffer));
  end;
end;

Function GetBrowserString(NStr,FormIdent: String; Arr: Integer;
                          var JChar: String): String;
var S,FeldName,AStr: String;
begin
  S:= '';
  JChar:= '|^';
  FeldName:= Copy(NStr,1,Pos(':',NStr)-1);
  Strip(FeldName);
  if Arr > 0 then begin
    Str(Arr,AStr);
    FeldName:= FeldName+'['+AStr+']';
  end;
  if (Length(FeldName) > 0) and (Pos('DUMMY',NStr) = 0)
  and (Pos('MEMO',NStr) = 0) and (Pos('IGNORE',NStr) = 0) then begin
    if Pos('WORD',NStr) > 0 then begin
      if (Pos('DATUM',NStr) > 0) or (Pos('DATE',NStr) > 0) then begin
        S:= 'DateStr('+FeldName+')';
      end
      else begin
        S:= 'DelSpace(IntStr('+FeldName+'))';
        JChar:= '^';
      end;
    end
    else if Pos('INTEGER',NStr) > 0 then begin
      S:= 'DelSpace(IntStr('+FeldName+'))';
      JChar:= '^';
    end
    else if Pos('BYTE',NStr) > 0 then begin
      S:= 'DelSpace(IntStr('+FeldName+'))';
      JChar:= '^';
    end
    else if Pos('LONGINT',NStr) > 0 then begin
      if (Pos('DATUM',NStr) > 0) or (Pos('DATE',NStr) > 0) then begin
        S:= 'DateStr('+FeldName+')';
      end
      else begin
        S:= 'DelSpace(IntStr('+FeldName+'))';
        JChar:= '^';
      end;
    end
    else if Pos('REAL',NStr) > 0 then begin
      S:= 's:= DelSpace(SimpleFormDezStr('+FeldName+',12,2))';
      JChar:= '^';
    end
    else if (Pos('CHAR',NStr) > 0) and (Pos('ARRAY',NStr) = 0) then begin
      S:= FeldName;
    end
    else if (Pos('BOOLEAN',NStr) > 0) then begin
      S:= 'BoolStr('+FeldName+')';
    end
    else S:= 'String_oem2ansi(Table.AnsiConvert,'+FeldName+')'
  end;
  GetBrowserString:= S;
end;

Function GetFieldTypEditor(S: String;
                           var FieldName: String;
                           var FieldDataType: TFieldType;
                           var Len: Integer;
                           var Arr1,Arr2: Integer;
                           var Decimals: Integer): Byte;
var G: Byte;
    x,Code,A1,A2,xPos: Integer;
    SStr,AStr,A1Str,NStr: String;
begin
  Arr1:= 1;
  Arr2:= 1;
  Decimals:= 0;
  SStr:= UpperCase(S);
  AStr:= SStr;
  if (Pos('ARRAY[',AStr) > 0) and (Pos('CHAR',Astr) = 0) then begin
    Delete(AStr,1,Pos('ARRAY[',AStr)+5);
    if Pos(']',AStr) > 0 then begin
      AStr:= Copy(AStr,1,Pos(']',AStr)-1);
      if Pos('.',AStr) > 0 then begin
        A1Str:= Copy(AStr,1,Pos('.',AStr)-1);
        While (Pos('.',AStr) > 0) do Delete(AStr,1,Pos('.',AStr));
        Strip(a1Str); Strip(AStr);
        Val(A1Str,A1,Code);
        Val(AStr,A2,Code);
        if (A1 > 0) and (A2 > 0) then begin
          Arr1:= A1;
          Arr2:= A2;
          if Arr1 > Arr2 then begin
            A1:= Arr2;
            Arr2:= Arr1;
            Arr1:= A1;
          end;
        end;
      end;
    end;
  end;
  if (Pos('DATUM',SStr) > 0) or (Pos('DATE',SStr) > 0) then begin
    G:= 1;
    FieldDataType:= ftDate;
    Len:= 10;
  end
  else if (Pos('REAL',SStr) > 0) or (Pos('INTEGER',SStr) > 0)
  or (Pos('BYTE',SStr) > 0) or (Pos('WORD',SStr) > 0)
  or (Pos('LONGINT',SStr) > 0) then begin
    G:= 2;
    if Pos('REAL',SStr) > 0 then begin
      FieldDataType:= ftFLOAT;
      Len:= 10;
      Decimals:= 2;
      NStr:= SStr;
      Strip(NStr);
      xPos:= Pos('{NACHK',NStr);
      if xPos > 0 then begin
        Delete(NStr,1,Pos('{NACHK',NStr)+5);
        if Pos('OMMASTELLEN',NStr) > 0 then Delete(NStr,Pos('OMMASTELLEN',NStr),11);
        if Pos('=',NStr) > 0 then Delete(NStr,Pos('=',NStr),1);
        xPos:= Pos('}',NStr);
        if xPos > 0 then begin
          NStr:= Copy(NStr,1,xPos-1);
          Strip(NStr);
          Val(NStr,x,Code);
          if x > 0 then Decimals:= x;
        end;
      end
      else begin
        xPos:= Pos('{DECIMALS=',NStr);
        if xPos > 0 then begin
          Delete(NStr,1,Pos('{DECIMALS=',NStr)+9);
          xPos:= Pos('}',NStr);
          if xPos > 0 then begin
            NStr:= Copy(NStr,1,xPos-1);
            Strip(NStr);
            Val(NStr,x,Code);
            if x > 0 then Decimals:= x;
          end;
        end;
      end;
    end
    else if Pos('INTEGER',SStr) > 0 then begin
      FieldDataType:= ftSMALLINT;
      Len:= 8;
    end
    else if Pos('BYTE',SStr) > 0 then begin
      FieldDataType:= ftSMALLINT;
      Len:= 4;
    end
    else if Pos('WORD',SStr) > 0 then begin
      FieldDataType:= ftWORD;
      Len:= 8;
    end
    else begin
      FieldDataType:= ftINTEGER;
      Len:= 12;
    end;
  end
  else if (Pos('MEMO',SStr) > 0) then begin
    G:= 3;
    FieldDataType:= ftMEMO;
    Len:= 255;
  end
  else if (Pos('BOOLEAN',SStr) > 0) then begin
    G:= 4;
    FieldDataType:= ftBOOLEAN;
    Len:= 2;
  end
  else begin
    G:= 0;
    FieldDataType:= ftString;
    Strip(SStr);
    Len:= 255;
    if Pos('ARRAY[',SStr) > 0 then begin
      Delete(SStr,1,Pos(']',SStr));
      if SStr[1] = ']' then Delete(SStr,1,1);
    end
    else if Pos('CHAR',SStr) > 0 then Len:= 1;
    if Pos('[',SStr) > 0 then begin
      Delete(SStr,1,Pos('[',SStr));
      if Pos(']',SStr) > 0 then begin
        SStr:= Copy(SStr,1,Pos(']',SStr)-1);
        Val(SStr,Len,Code);
      end;
    end;
  end;
  Strip(S);
  FieldName:= Copy(S,1,Pos(':',S)-1);
  Strip(FieldName);
  GetFieldTypEditor:= G;
end;

Procedure GetArray(AStr: String; var Arr1,Arr2: Integer);
var A1Str: String;
    A1,A2,Code: Integer;
begin
  Arr1:= 1;
  Arr2:= 1;
  if (Pos('ARRAY[',AStr) > 0) and (Pos('CHAR',Astr) = 0) then begin
    Delete(AStr,1,Pos('ARRAY[',AStr)+5);
    if Pos(']',AStr) > 0 then begin
      AStr:= Copy(AStr,1,Pos(']',AStr)-1);
      if Pos('.',AStr) > 0 then begin
        A1Str:= Copy(AStr,1,Pos('.',AStr)-1);
        While (Pos('.',AStr) > 0) do Delete(AStr,1,Pos('.',AStr));
        Strip(a1Str); Strip(AStr);
        Val(A1Str,A1,Code);
        Val(AStr,A2,Code);
        if (A1 > 0) and (A2 > 0) then begin
          Arr1:= A1;
          Arr2:= A2;
          if Arr1 > Arr2 then begin
            A1:= Arr2;
            Arr2:= Arr1;
            Arr1:= A1;
          end;
        end;
      end;
    end;
  end;
end;

function Erzeuge_BrowserSource(const UnitIdent, FormIdent,
                               EditUnitIdent,EditFormIdent: String;
                               Parent: TForm;
                               Sprache: Integer;
                               TypDateiName, OrigPas: String): TMemoryStream;
const
  CRLF = #13#10;
Var Decimals,Len,fnx,I,rx,k,arr1,arr2,a,Feld: integer;
    G: Byte;
    BStr,SStr,RStr,xStr,NStr,DbFldNam : String;
    ArrName,Zeichen,RecordName,FldNam,FeldName: String;
    DBase_Export,DBase_Import, XLExport: Boolean;
    CreaBttn, SetupBttnCheck,alsMainform: Boolean;
    StruFileName,AliasName,ProtoName: String;
    DBFeldList: TStringList;
    JustChar,MemoName: String;
    FieldDataType: TFieldType;
    Exp: TIsamMainForm;
    TempSrc, SrcCode: TStringList;
    Zeile, idx: Integer;
    CommentIgnorieren,Ignorieren,Impl: Boolean;
    GStr : String;
    PS   : Array[0..255] of Char;

  Procedure Einfuegen(var S: String; CodeNr,x1Pos: Integer);
  var i,a,x: Integer;
  begin
    Delete(S,x1Pos,4);
    Case CodeNr of
      2 : Insert(EditFormIdent,S,x1Pos);
      3 : Insert(UnitIdent, S, x1Pos);
      4 : Insert(FormIdent, S, x1Pos);
      5 : if (DBASE_Export) or (DBASE_Import) then Insert(EditUnitIdent+', '+StruFileName, S, x1Pos)
          else Insert(EditUnitIdent,S,x1Pos);
      6 : Insert(RecordName, S, x1Pos);
      7 : If (DBASE_Export = False) and (DBASE_Import = False) then
          Insert('Isam2Dbf',S,x1Pos) else Insert('Isam2Dbf, Dbf2Isam',S,x1Pos);
      8 : if XLExport then Insert('Isam2XLS, WINSAVE,',S,x1Pos);
      9 : Insert(AliasName, S, x1Pos);
      17: begin {KeyListe}
            S:= '*';
            if Exp.KeyList.Count > 0 then begin
              For i:= 0 to Exp.KeyList.Count-1 do begin
                NStr:= Exp.KeyList[i];
                if Pos('S:=',NStr) > 0 then begin
                  Delete(NStr,1,Pos('S:=',NStr)+2);
                  While (Length(NStr) > 0) and (NStr[1] = ' ') do Delete(NStr,1,1);
                  if Pos(',',NStr) > 0 then NStr:= Copy(NStr,1,Pos(',',NStr)-1)
                  else if Pos(';',NStr) > 0 then NStr:= Copy(NStr,1,Pos(';',NStr)-1)
                  else if Pos('{',NStr) > 0 then NStr:= Copy(NStr,1,Pos('{',NStr)-1);
                  if Pos('}',NStr) > 0 then Delete(NStr,1,Pos('}',NStr));
                  While Pos('(',NStr) > 0 do Delete(NStr,1,Pos('(',NStr));
                  if Pos(')',NStr) > 0 then NStr:= Copy(NStr,1,Pos(')',NStr)-1);
                  While (Length(NStr) > 0) and (NStr[1] = ' ') do Delete(NStr,1,1);
                  TempSrc.Add('  KeyListe.Add('+Chr(39)+NStr+Chr(39)+');');
                end;
              end;
            end;
          end; {17}
     18 : Insert(TypDateiName, S, x1Pos);
     20 : begin {GetFeldProc}
            S:= '*';
            if Exp.RecList.Count > 0 then begin
              Feld:= 0;
              For x:= 0 to Exp.RecList.Count-1 do begin
                NStr:= Exp.RecList[x];
                NStr:= Uppercase(NStr);
                Strip(NStr);
                if (Pos(':',NStr) > 0) then begin
                  GetArray(NStr,Arr1,Arr2);
                  if Arr1 = Arr2 then begin
                    A:= 0;
                    JustChar:= '|^';
                    BStr:= GetBrowserString(NStr,FormIdent,A,JustChar);
                    if BStr <> '' then begin
                      Inc(Feld);
                      if Pos('REAL',NStr) > 0 then begin
                        JustChar := '^';
                        TempSrc.Add('      '+DezStr(Feld)+': '+BStr+'+'+Chr(39)+JustChar+Chr(39)+';');
                      end
                      else TempSrc.Add('      '+DezStr(Feld)+': s:= '+BStr+'+'+Chr(39)+JustChar+Chr(39)+';');
                    end;
                  end
                  else begin
                    For a:= arr1 to Arr2 do begin
                      BStr:= GetBrowserString(NStr,FormIdent,A,JustChar);
                      JustChar:= '|^';
                      if BStr <> '' then begin
                        Inc(Feld);
                        if Pos('REAL',NStr) > 0 then begin
                          JustChar := '^';
                          TempSrc.Add('      '+DezStr(Feld)+': '+BStr+'+'+Chr(39)+JustChar+Chr(39)+';');
                        end
                        else TempSrc.Add('      '+DezStr(Feld)+': s:= '+BStr+'+'+Chr(39)+JustChar+Chr(39)+';');
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end; {20}
     21 : begin {DbaseExportProc}
            S:= '*';
            DBFeldList.Clear;
            if Exp.RecList.Count > 0 then begin
              For X:= 0 to Exp.RecList.Count-1 do begin
                RStr:= Exp.RecList[x];
                RStr:= UpperCase(RStr);
                Strip(RStr);
                if (Pos(':',RStr) > 0) and (Pos('DUMMY',RStr) = 0) then begin
                  GetArray(RStr,Arr1,Arr2);
                  FldNam:= Copy(RStr,1,Pos(':',RStr)-1);
                  Strip(FldNam);
                  DBFldNam:= FldNam;
                  if Length(DBFldNam) > 8 then DBFldNam:= Copy(DBFldNam,1,8);
                  FeldName:= DBFldNam;
                  ArrName:= FldNam;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      FeldName:= Copy(DbFldNam,1,6) + DezStr(a);
                      ArrName:= FldNam + '['+DezStr(a)+']';
                    end;
                    if DBFeldList.Indexof(FeldName) > -1 then begin
                      fnx:= 1;
                      Repeat
                        inc(fnx);
                        FeldName:= Copy(DBFldNam,1,6)+DezStr(fnx);
                      Until DBFeldList.Indexof(FeldName) = -1;
                    end;
                    DBFeldList.Add(FeldName);
                    Zeichen:= Chr(39);
                    if Pos('WORD',RStr) > 0 then begin
                      if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                        TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsString:= DateStr('+ArrName+');');
                      end
                      else begin
                        TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger:= '+ArrName+';');
                      end;
                    end
                    else if Pos('INTEGER',RStr) > 0 then begin
                      TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger:= '+ArrName+';');
                    end
                    else if Pos('BYTE',RStr) > 0 then begin
                      TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger:= '+ArrName+';');
                    end
                    else if Pos('LONGINT',RStr) > 0 then begin
                      if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                        TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsString:= DateStr('+ArrName+');');
                      end
                      else begin
                        TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger:= '+ArrName+';');
                      end
                    end
                    else if Pos('REAL',RStr) > 0 then begin
                      TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsFloat:= '+ArrName+';');
                    end
                    else if Pos('BOOLEAN',RStr) > 0 then begin
                      TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsBoolean:= '+ArrName+';');
                    end
                    else if Pos('MEMO',RStr) > 0 then begin
                      TempSrc.Add('    M:= TMemo.Create(Application);');
                      TempSrc.Add('    Move('+ArrName+',MStr,Sizeof('+ArrName+'));');
                      TempSrc.Add('    M.SetTextBuf(MStr);');
                      TempSrc.Add('    TMemoField(DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+')).Assign(M.Lines);');
                      TempSrc.Add('    M.Free;');
                    end
                    else begin
                      TempSrc.Add('    DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+
                                  ').AsString:= String_oem2ansi(ISTable.AnsiConvert,'+ArrName+');');
                    end;
                  end;
                end;
              end;
            end;
          end; {21}
     22 : begin {DbaseImportProc}
            S:= '*';
            if DBASE_Import then begin
              DBFeldList.Clear;
              if Exp.RecList.Count > 0 then begin
                For X:= 0 to Exp.RecList.Count-1 do begin
                  RStr:= Exp.RecList[x];
                  RStr:= UpperCase(RStr);
                  Strip(RStr);
                  if (Pos(':',RStr) > 0) and (Pos('DUMMY',RStr) = 0) then begin
                    GetArray(RStr,Arr1,Arr2);
                    FldNam:= Copy(RStr,1,Pos(':',RStr)-1);
                    Strip(FldNam);
                    DBFldNam:= FldNam;
                    if Length(DBFldNam) > 8 then DBFldNam:= Copy(DBFldNam,1,8);
                    FeldName:= DBFldNam;
                    ArrName:= FldNam;
                    For a:= Arr1 to Arr2 do begin
                      if Arr1 <> Arr2 then begin
                        FeldName:= Copy(DbFldNam,1,6) + DezStr(a);
                        ArrName:= FldNam + '[' + DezStr(a) + ']';
                      end;
                      if DBFeldList.Indexof(FeldName) > -1 then begin
                        fnx:= 1;
                        Repeat
                          inc(fnx);
                          FeldName:= Copy(DBFldNam,1,6)+DezStr(fnx);
                        Until DBFeldList.Indexof(FeldName) = -1;
                      end;
                      DBFeldList.Add(FeldName);
                      Zeichen:= Chr(39);
                      if Pos('WORD',RStr) > 0 then begin
                        if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                          TempSrc.Add('    '+ArrName+':= StrDate(DBTable.FieldByName('
                                      +Chr(39)+FeldName+Chr(39)+').AsString);');
                        end
                        else begin
                          TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger;');
                        end;
                      end
                      else if Pos('INTEGER',RStr) > 0 then begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger;');
                      end
                      else if Pos('BYTE',RStr) > 0 then begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger;');
                      end
                      else if Pos('LONGINT',RStr) > 0 then begin
                        if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                          TempSrc.Add('    '+ArrName+':= StrDate(DBTable.FieldByName('
                                      +Chr(39)+FeldName+Chr(39)+').AsString);');
                        end            
                        else begin
                          TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsInteger;');
                        end;
                      end
                      else if Pos('REAL',RStr) > 0 then begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsFloat;');
                      end
                      else if Pos('BOOLEAN',RStr) > 0 then begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsBoolean;');
                      end
                      else if Pos('MEMO',RStr) > 0 then begin
                        TempSrc.Add('    M:= TMemo.Create(Application);');
                        TempSrc.Add('    M.Lines.Assign(DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+'));');
                        TempSrc.Add('    M.GetTextBuf(MStr,800);');
                        TempSrc.Add('    Move(MStr,'+ArrName+',Sizeof('+ArrName+'));');
                        TempSrc.Add('    M.Free;');
                      end
                      else if (Pos('CHAR',RStr) > 0) and (Pos('ARRAY',RStr) = 0) then begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsString[1];');
                      end
                      else begin
                        TempSrc.Add('    '+ArrName+':= DBTable.FieldByName('+Chr(39)+FeldName+Chr(39)+').AsString;');
                      end;
                    end;
                  end;
                end;
              end;
            end;
          end; {22}
     23 : begin {KeyProc}
            S:= '*';
            if Exp.KeyList.Count > 0 then begin
              k:= 0;
              For x:= 0 to Exp.KeyList.Count-1 do begin
                NStr:= Exp.KeyList[x];
                NStr:= UpperCase(NStr);
                Strip(NStr);
                if (Pos('KEYBEGIN',NStr) = 0) and (Pos('KEYEND',NStr) = 0) then begin
                  inc(K);
                  Str(k,xStr);
                  TempSrc.Add('      '+xStr+': '+Exp.KeyList[x]);
                end;
              end;
            end
            else TempSrc.Add('      1 : S:= '+Chr(39)+Chr(39)+';');
          end; {23}
     24 : begin {IIDListe}
            S:= '*';
            if Exp.IidList.Count > 0 then begin
              For x:= 0 to Exp.IidList.Count-1 do
              TempSrc.Add('    '+Exp.IidList[x]);
            end
            else TempSrc.Add('    IID[1].KeyL := 0; IID[1].AllowDupK := False;');
          end; {24}
     25 : begin {xlExport - berschriften}
            S:= '*';
            if (XLExport) and (Exp.RecList.Count > 0) then begin
              DBFeldList.Clear;
              For X:= 0 to Exp.RecList.Count-1 do begin
                RStr:= Exp.RecList[x];
                RStr:= UpperCase(RStr);
                Strip(RStr);
                if (Pos(':',RStr) > 0) and (Pos('DUMMY',RStr) = 0)
                and (Pos('IGNORE',RStr) = 0) and (Pos('MEMO',RStr) = 0)
                then begin
                  GetArray(RStr,Arr1,Arr2);
                  FldNam:= Copy(RStr,1,Pos(':',RStr)-1);
                  Strip(FldNam);
                  DBFldNam:= FldNam;
                  if Length(DBFldNam) > 8 then DBFldNam:= Copy(DBFldNam,1,8);
                  FeldName:= DBFldNam;
                  ArrName:= FldNam;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      FeldName:= Copy(DbFldNam,1,6) + DezStr(a);
                      ArrName:= FldNam + '['+DezStr(a)+']';
                    end;
                    if DBFeldList.Indexof(FeldName) > -1 then begin
                      fnx:= 1;
                      Repeat
                        inc(fnx);
                        FeldName:= Copy(DBFldNam,1,6)+DezStr(fnx);
                      Until DBFeldList.Indexof(FeldName) = -1;
                    end;
                    DBFeldList.Add(FeldName);
                    TempSrc.Add('    S:= '+Chr(39)+FeldName+Chr(39)+';');
                    TempSrc.Add('    StrPCopy(aLabel,S);');
                    TempSrc.Add('    PSaveFile^.WriteData(CellLabel,Zeile,Spalte,@ALabel);');
                    TempSrc.Add('    inc(Spalte);');
                  end;
                end;
              end;
            end;
          end;  {25}
     26 : begin {xlExport - Daten}
            S:= '*';
            if (XLExport) and (Exp.RecList.Count > 0) then begin
              DBFeldList.Clear;
              For X:= 0 to Exp.RecList.Count-1 do begin
                RStr:= Exp.RecList[x];
                RStr:= UpperCase(RStr);
                Strip(RStr);
                if (Pos(':',RStr) > 0) and (Pos('DUMMY',RStr) = 0)
                and (Pos('IGNORE',RStr) = 0) and (Pos('MEMO',RStr) = 0)
                then begin
                  GetArray(RStr,Arr1,Arr2);
                  FldNam:= Copy(RStr,1,Pos(':',RStr)-1);
                  Strip(FldNam);
                  DBFldNam:= FldNam;
                  if Length(DBFldNam) > 8 then DBFldNam:= Copy(DBFldNam,1,8);
                  FeldName:= DBFldNam;
                  ArrName:= FldNam;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      FeldName:= Copy(DbFldNam,1,6) + DezStr(a);
                      ArrName:= FldNam + '['+DezStr(a)+']';
                    end;
                    if DBFeldList.Indexof(FeldName) > -1 then begin
                      fnx:= 1;
                      Repeat
                        inc(fnx);
                        FeldName:= Copy(DBFldNam,1,6)+DezStr(fnx);
                      Until DBFeldList.Indexof(FeldName) = -1;
                    end;
                    DBFeldList.Add(FeldName);
                    if Pos('WORD',RStr) > 0 then begin
                      if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                        TempSrc.Add('    S:= DateStr('+ArrName+');');
                        TempSrc.Add('    StrPCopy(aLabel,S);');
                        TempSrc.Add('    PSaveFile^.WriteData(CellLabel,Zeile,Spalte,@ALabel);');
                        TempSrc.Add('    inc(Spalte);');
                      end
                      else begin
                        TempSrc.Add('    I:= '+ArrName+';');
                        TempSrc.Add('    PSaveFile^.WriteData(CellInteger,Zeile,Spalte,@I);');
                        TempSrc.Add('    inc(Spalte);');
                      end;
                    end
                    else if (Pos('INTEGER',RStr) > 0) or (Pos('BYTE',RStr) > 0) then begin
                      TempSrc.Add('    I:= '+ArrName+';');
                      TempSrc.Add('    PSaveFile^.WriteData(CellInteger,Zeile,Spalte,@I);');
                      TempSrc.Add('    inc(Spalte);');
                    end
                    else if Pos('LONGINT',RStr) > 0 then begin
                      if (Pos('DATUM',RStr) > 0) or (Pos('DATE',RStr) > 0) then begin
                        TempSrc.Add('    S:= DateStr('+ArrName+');');
                        TempSrc.Add('    StrPCopy(aLabel,S);');
                        TempSrc.Add('    PSaveFile^.WriteData(CellLabel,Zeile,Spalte,@ALabel);');
                        TempSrc.Add('    inc(Spalte);');
                      end
                      else begin
                        TempSrc.Add('    D:= '+ArrName+';');
                        TempSrc.Add('    PSaveFile^.WriteData(CellDouble,Zeile,Spalte,@D);');
                        TempSrc.Add('    inc(Spalte);');
                      end
                    end
                    else if Pos('REAL',RStr) > 0 then begin
                      TempSrc.Add('    D:= '+ArrName+';');
                      TempSrc.Add('    PSaveFile^.WriteData(CellDouble,Zeile,Spalte,@D);');
                      TempSrc.Add('    inc(Spalte);');
                    end
                    else if Pos('BOOLEAN',RStr) > 0 then begin
                      TempSrc.Add('    B:= '+ArrName+';');
                      TempSrc.Add('    PSaveFile^.WriteData(CellBoolean,Zeile,Spalte,@B);');
                      TempSrc.Add('    inc(Spalte);');
                    end
                    else begin
                      TempSrc.Add('    S:= String_oem2ansi(ISTable.AnsiConvert,'+ArrName+');');
                      TempSrc.Add('    StrPCopy(aLabel,S);');
                      TempSrc.Add('    PSaveFile^.WriteData(CellLabel,Zeile,Spalte,@ALabel);');
                      TempSrc.Add('    inc(Spalte);');
                    end;
                  end;
                end;
              end;
            end;
          end; {26}
    end;  {CASE CODENR}
  end;

  Procedure Auswerten(S: String);
  var xStr: String;
      x1Pos, x2Pos, CodeNr, Code: Integer;
      PS  : Array[0..255] of Char;
  begin
    xStr:= S;
    CodeNr:= 0;
    x1Pos:= Pos('%',xStr);
    if x1Pos > 0 then begin
      While x1Pos > 0 do begin
        Delete(xStr,1,x1Pos);
        x2Pos:= Pos('%',xStr);
        if x2Pos > 0 then begin
          xStr:= Copy(xStr,1,x2Pos-1);
          Val(xStr,CodeNr,Code);
        end;
        if CodeNr > 0 then Einfuegen(S,CodeNr,x1Pos);
        xStr:= S;
        CodeNr:= 0;
        x1Pos:= Pos('%',xStr);
      end;
    end;
    if S <> '*' then TempSrc.Add(S);
  end;

begin {Erzeuge_BrowserSource}
  Exp:= TIsamMainForm(Parent);
  DBase_Export:= Exp.DbaseExpCheck.Checked;
  DBase_Import:= Exp.DBaseImpCheck.Checked;
  XLExport:= Exp.XLExpCheck.Checked;
  CreaBttn:= Exp.TblCreatCheck.Checked;
  SetupBttnCheck:= Exp.BrwSetupCheck.Checked;
  alsMainform:= Exp.BrwHauptCheck.Checked;
  StruFileName:= Exp.DBStruEdit.Text;
  AliasName:= Exp.AliasEdit.Text;
  ProtoName:= Exp.BrwProtoEdit.Text;
  DBFeldList:= TStringList.Create;
  RecordName:= '';
  MemoName:= '';
  if Exp.RecList.Count > 0 then begin
    For rx:= 0 to Exp.RecList.Count-1 do begin
      RStr:= Exp.RecList[rx];
      RStr:= UpperCase(RStr);
      Strip(RStr);
      if Pos('=RECORD',RStr) > 0 then begin
        RStr:= Copy(RStr,1,Pos('=RECORD',RStr)-1);
        Strip(RStr);
        RecordName:= RStr;
      end;
      if (Pos(':',RStr) > 0) and (Pos('DUMMY',UpperCase(RStr)) = 0)
      and (Pos('IGNORE',Uppercase(RStr)) = 0) then begin
        G:= GetFieldTypEditor(RStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
        if G = 3 then MemoName:= FeldName;
      end;
    end;
  end;
  TempSrc:= TStringList.Create;
  CommentIgnorieren:= False;
  SrcCode:= TStringList.Create;
  SrcCode.LoadFromFile(ProtoName);
  if SrcCode.Count = 0 then MessageDlg(ProtoName+' konnte nicht geladen werden', mtError, [mbOk], 0)
  else begin
    Zeile:= 0;
    Ignorieren:= False;
    Impl:= False;
    Repeat
      SStr:= SrcCode[Zeile];
      GStr:= UpperCase(SStr);
      if Pos('IMPLEMENTATION',GStr) > 0 then Impl:= True;
      if Pos('END.',GStr) > 0 then Impl:= False;
      if Pos('(*****',GStr) > 0 then CommentIgnorieren:= True;
      if ((Pos('FUNCTION',GStr) > 0) or (Pos('PROCEDURE',GStr) > 0)
      or ( Pos('TSPEEDBUTTON',GStr) > 0)) then begin
        if ((SetupBttnCheck = False) and (Pos('SETUPBTTN',GStr) > 0))
        or ((CreaBttn = False) and (Pos('CREATEBTTN',GStr) > 0))
        or ((Dbase_Export = False) and (Pos('DBEXPBTTN',GStr) > 0))
        or ((DBase_Import = False) and (Pos('DBIMPBTTN',GStr) > 0))
        or ((XLExport = False) and ((Pos('XLBTTN',GStr) > 0) or (Pos('XLEXPORTPROC',GStr) > 0)))
        then Ignorieren:= True
        else Ignorieren:= False;
      end;
      (*if (Impl) and (OrigPas <> '') and (Ignorieren = False) then begin
      {neu, damit nur die selektierten Procs upgedatet werden}
        if ((Pos('FUNCTION',GStr) > 0) or (Pos('PROCEDURE',GStr) > 0)) then begin
          Idx:= Exp.Listbox1.Items.IndexOf(GetProcName(GStr));
          if (Idx < 0) or (Exp.Listbox1.Selected[idx] = False) then Ignorieren:= True
          else Ignorieren:= False;
        end;
      end;*)
      if (Ignorieren = False) and (CommentIgnorieren = False) then Auswerten(SStr);
      if Pos('*****)',GStr) > 0 then CommentIgnorieren:= False;
      Inc(Zeile);
    Until Zeile = SrcCode.Count;
    if OrigPas <> '' then begin
      if Exp.BrwProcUpdcheck.Checked then Proc_Update(TempSrc,OrigPas,Exp.Listbox1)
      else AltSource_Verwerten(TempSrc,OrigPas,Exp.CodeTable);
    end;
    SourceBuffer := StrAlloc(SourceBufferSize);
    try
      Result := TMemoryStream.Create;
      try
        if TempSrc.Count > 0 then begin
          For i:= 0 to TempSrc.Count-1 do begin
            SStr:= TempSrc[i];
            Strpcopy(Ps,SStr+CRLF);
            FmtWrite(Result,PS,[NIL]);
          end;
        end;
        Result.Position := 0;
      except
        Result.Free;
        raise;
      end;
    finally
      StrDispose(SourceBuffer);
    end;
  end;
  TempSrc.Free;
  SrcCode.Free;
  DbFeldList.Free;
end;

function Erzeuge_EditorSource(const UnitIdent, FormIdent: String;
                              Parent: TForm;
                              Sprache: Integer;
                              TypDateiName, ProtoName,
                              OrigPas: String): TMemoryStream;
const
  CRLF = #13#10;
Var Exp: TIsamMainForm;
    Decimals,Len: integer;
    G: Byte;
    FieldDataType: TFieldType;
    RecordName,FieldName,FeldName,FldName,NStr,SStr,RStr,AStr,DStr: String;
    BroIdent, StruIdent, AliasIdent: string;
    MemoName: String;
    CommentIgnorieren, Ignorieren, Impl: Boolean;
    TempSrc, SrcCode : TStringList;
    Zeile,Arr1,Arr2,r,idx: Integer;
    GStr             : String;
    PS               : Array[0..255] of Char;

  Procedure Einfuegen(var S: String; CodeNr,x1Pos: Integer);
  var i,a: Integer;
  begin
    Delete(S,x1Pos,4);
    Case CodeNr of
      1 : Insert(UnitIdent, S, x1Pos);
      2 : Insert(FormIdent, S, x1Pos);
      5 : if StruIdent <> '' then Insert(BroIdent+', '+StruIdent, S, x1Pos)
          else Insert(BroIdent, S, x1Pos);
      6 : Insert(RecordName, S, x1Pos);
      9 : Insert(AliasIdent, S, x1Pos);
      10: begin
            S:= '*';
            if Exp.RecList.Count > 0 then begin
              For i:= 0 to Exp.RecList.Count-1 do begin
                SStr:= Exp.RecList[i];
                if (Pos(':',SStr) > 0) and (Pos('DUMMY',UpperCase(SStr)) = 0)
                and (Pos('IGNORE',Uppercase(SStr)) = 0) then begin
                  G:= GetFieldTypEditor(SStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
                  FieldName:= FeldName;
                  FldName:= FeldName;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      Str(A,AStr);
                      FieldName:= FeldName+AStr;
                    end;
                    {$IFDEF NEWINPUTS}
                    Case G of
                      1: begin
                           TempSrc.Add('    '+FieldName+'Input: TDateEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      2: begin
                           TempSrc.Add('    '+FieldName+'Input: TNumEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      3: begin
                           TempSrc.Add('    '+FieldName+'Input: TMemo;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      4: begin
                           TempSrc.Add('    '+FieldName+'Input: TRadioGroup;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      else begin
                           TempSrc.Add('    '+FieldName+'Input: TStrEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                      end;
                    end;
                    {$ELSE}
                    Case G of
                      1: begin
                           TempSrc.Add('    '+FieldName+'Input: TEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      2: begin
                           TempSrc.Add('    '+FieldName+'Input: TEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      3: begin
                           TempSrc.Add('    '+FieldName+'Input: TMemo;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                         end;
                      4: begin
                           TempSrc.Add('     '+FieldName+'Input: TRadioGroup;');
                           TempSrc.Add('     '+FieldName+'Label: TLabel;');
                         end;
                      else begin
                           TempSrc.Add('    '+FieldName+'Input: TEdit;');
                           TempSrc.Add('    '+FieldName+'Label: TLabel;');
                      end;
                    end;
                    {$ENDIF}
                  end; {for arr1 to arr2}
                end;
              end;
            end;
          end;
      11: begin
           {$IFDEF NEWINPUTS}
            Insert('DateEdit, NumCtrl,',S, x1Pos);
           {$ENDIF}
          end;
      12: begin
            S:= '*';
            {$IFDEF NEWINPUTS}
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TDateEdit) then begin');
            TempSrc.Add('        if TDateEdit(Components[i]).Modified then M:= True;');
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TNumEdit) then begin');
            TempSrc.Add('        if TNumEdit(Components[i]).Modified then M:= True;');
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TStrEdit) then begin');
            TempSrc.Add('        if TStrEdit(Components[i]).Modified then M:= True;');
            {$ENDIF}
          end;
      13: begin
            S:= '*';
            {$IFDEF NEWINPUTS}
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TDateEdit) then begin');
            TempSrc.Add('        TDateEdit(Components[i]).Modified := False;');
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TNumEdit) then begin');
            TempSrc.Add('        TNumEdit(Components[i]).Modified := False;');
            TempSrc.Add('      end');
            TempSrc.Add('      else if (Components[i] is TStrEdit) then begin');
            TempSrc.Add('        TStrEdit(Components[i]).Modified := False;');
            {$ENDIF}
          end;
      14: begin
            S:= '*';
            if Exp.RecList.Count > 0 then begin
              For i:= 0 to Exp.RecList.Count-1 do begin
                SStr:= Exp.RecList[i];
                if (Pos(':',SStr) > 0) and (Pos('DUMMY',UpperCase(SStr)) = 0)
                and (Pos('IGNORE',Uppercase(SStr)) = 0) then begin
                  G:= GetFieldTypEditor(SStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
                  FieldName:= FeldName;
                  FldName:= FeldName;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      Str(A,AStr);
                      FieldName:= FeldName+'['+AStr+']';
                      FldName:= FeldName + AStr;
                    end;
                    case FieldDataType of
                      {$IFDEF NEWINPUTS}
                      ftSmallInt,
                      ftBytes   : TempSrc.Add('    '+FldName+'Input.Value:= '+FieldName+';');
                      ftWord,
                      ftInteger : TempSrc.Add('    '+FldName+'Input.Value:= '+FieldName+';');
                      ftDate    : TempSrc.Add('      '+FldName+'Input.Text:= DateStr('+FieldName+');');
                      ftFloat   : TempSrc.Add('    '+FldName+'Input.Value:= '+FieldName+';');
                      ftMemo    : begin
                                    TempSrc.Add('    Move('+FieldName+',MStr,Sizeof('+FieldName+'));');
                                    TempSrc.Add('    '+FldName+'Input.SetTextBuf(MStr);');
                                  end;
                      ftBoolean : TempSrc.Add('    if '+FieldName+' then '+FldName+'Input.ItemIndex:= 1 else '+
                                                FldName+'Input.ItemIndex:= 0;');
                      else begin
                        if Len = 1 then TempSrc.Add('    '+FldName+'Input.Text:= '+FieldName+';')
                        else TempSrc.Add('    '+FldName+'Input.Text:= String_oem2ansi('+FormIdent+'Table.AnsiConvert,'
                                         +FieldName+');');
                      end;
                      {$ELSE}
                      ftSmallInt,
                      ftBytes   : TempSrc.Add('    '+FldName+'Input.Text:= IntStr('+FieldName+');');
                      ftWord,
                      ftInteger : TempSrc.Add('    '+FldName+'Input.Text:= IntStr('+FieldName+');');
                      ftDate    : TempSrc.Add('    '+FldName+'Input.Text:= DateStr('+FieldName+');');
                      ftFloat   : begin
                                    Str(Decimals,DStr);
                                    TempSrc.Add('    '+FldName+'Input.Text:= SimpleFormDezStr('+FieldName+',12,'+DStr+');');
                                  end;
                      ftMemo    : begin
                                    TempSrc.Add('    Move('+FieldName+',MStr,Sizeof('+FieldName+'));');
                                    TempSrc.Add('    '+FldName+'Input.SetTextBuf(MStr);');
                                  end;
                      ftBoolean : TempSrc.Add('    if '+FieldName+' then '+FldName+'Input.ItemIndex:= 1 else '+
                                             FldName+'Input.ItemIndex:= 0;');
                      else begin
                        if Len = 1 then TempSrc.Add('    '+FldName+'Input.Text:= '+FieldName+';')
                        else TempSrc.Add('    '+FldName+'Input.Text:= String_oem2ansi('+FormIdent+'Table.AnsiConvert,'+
                                         FieldName+');');
                      end;
                      {$ENDIF}
                    end; {CASE}
                  end; {for arr1 to arr2}
                end; {if}
              end; {for}
            end; {if Exp.RecList.Count}
          end;
      15: begin
            S:= '*';
            if Exp.RecList.Count > 0 then begin
              For i:= 0 to Exp.RecList.Count-1 do begin
                SStr:= Exp.RecList[i];
                if (Pos(':',SStr) > 0) and (Pos('DUMMY',UpperCase(SStr)) = 0)
                and (Pos('IGNORE',Uppercase(SStr)) = 0) then begin
                  G:= GetFieldTypEditor(SStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
                  FieldName:= FeldName;
                  FldName:= FeldName;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      Str(A,AStr);
                      FieldName:= FeldName+'['+AStr+']';
                      FldName:= FeldName + AStr;
                    end;
                    Case FieldDataType of
                      ftSmallInt,
                      ftBytes   : TempSrc.Add('    '+FieldName+':= StrInt ('+FldName+'Input.Text);');
                      ftWord,
                      ftInteger : TempSrc.Add('    '+FieldName+':= StrInt('+FldName+'Input.Text);');
                      ftDate    : TempSrc.Add('    '+FieldName+':= StrDate('+FldName+'Input.Text);');
                      ftFloat   : TempSrc.Add('    '+FieldName+':= StrDez ('+FldName+'Input.Text);');
                      ftMemo    : begin
                                    TempSrc.Add('    '+FldName+'Input.GetTextBuf(MStr,Sizeof('+FieldName+'));');
                                    TempSrc.Add('    Move(MStr,'+FieldName+',Sizeof('+FieldName+'));');
                                  end;
                      ftBoolean : TempSrc.Add('    '+FieldName+':= ('+FldName+'Input.ItemIndex = 1);');
                      else begin
                        if Len = 1 then TempSrc.Add('    '+FieldName+':= '+FldName+'Input.Text[1];')
                        else TempSrc.Add('    '+FieldName+':= String_ansi2oem('+FormIdent+'Table.AnsiConvert,'+
                                         FldName+'Input.Text);');
                      end;
                    end; {CASE}
                  end;  {for arr1 to arr2}
                end; {if}
              end; {for}
            end; {if}
          end;{15}
      16: begin
            S:= '*';
            if Exp.RecList.Count > 0 then begin
              For i:= 0 to Exp.RecList.Count-1 do begin
                SStr:= Exp.RecList[i];
                if (Pos(':',SStr) > 0) and (Pos('DUMMY',UpperCase(SStr)) = 0)
                and (Pos('IGNORE',Uppercase(SStr)) = 0) then begin
                  G:= GetFieldTypEditor(SStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
                  FieldName:= FeldName;
                  FldName:= FeldName;
                  For a:= Arr1 to Arr2 do begin
                    if Arr1 <> Arr2 then begin
                      Str(A,AStr);
                      FieldName:= FeldName+'['+AStr+']';
                      FldName:= FeldName + AStr;
                    end;
                    Case FieldDataType of
                      {$IFDEF NEWINPUTS}
                      ftSmallInt,
                      ftBytes   : TempSrc.Add('  '+FldName+'Input.Value:= 0;');
                      ftInteger,
                      ftWord    : TempSrc.Add('  '+FldName+'Input.Value:= 0;');
                      ftDate    : TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+Chr(39)+';');
                      ftFloat   : TempSrc.Add('  '+FldName+'Input.Value:= 0;');
                      ftMemo    : TempSrc.Add('  '+FldName+'Input.Lines.Clear;');
                      ftBoolean : TempSrc.Add('  '+FldName+'Input.ItemIndex:= 0;');
                      else TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+ Chr(39)+';');
                      {$ELSE}
                      ftSmallInt,
                      ftBytes   : TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+'0'+Chr(39)+';');
                      ftInteger,
                      ftWord,
                      ftDate    : TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+''+Chr(39)+';');
                      ftFloat   : TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+'0.00'+Chr(39)+';');
                      ftMemo    : TempSrc.Add('  '+FldName+'Input.Lines.Clear;');
                      ftBoolean : TempSrc.Add('  '+FldName+'Input.ItemIndex:= 0;');
                      else TempSrc.Add('  '+FldName+'Input.Text:= '+Chr(39)+ Chr(39)+';');
                      {$ENDIF}
                    end;{CASE}
                  end; {for arr1 to arr2}
                end; {if}
              end; {For}
            end; {if}
          end; {16}
      17: begin
            S:= '*';
            if Exp.KeyList.Count > 0 then begin
              For i:= 0 to Exp.KeyList.Count-1 do begin
                NStr:= Exp.KeyList[i];
                if Pos('S:=',NStr) > 0 then begin
                  Delete(NStr,1,Pos('S:=',NStr)+2);
                  While (Length(NStr) > 0) and (NStr[1] = ' ') do Delete(NStr,1,1);
                  if Pos(',',NStr) > 0 then NStr:= Copy(NStr,1,Pos(',',NStr)-1)
                  else if Pos(';',NStr) > 0 then NStr:= Copy(NStr,1,Pos(';',NStr)-1)
                  else if Pos('{',NStr) > 0 then NStr:= Copy(NStr,1,Pos('{',NStr)-1);
                  if Pos('}',NStr) > 0 then Delete(NStr,1,Pos('}',NStr));
                  While Pos('(',NStr) > 0 do Delete(NStr,1,Pos('(',NStr));
                  if Pos(')',NStr) > 0 then NStr:= Copy(NStr,1,Pos(')',NStr)-1);
                  While (Length(NStr) > 0) and (NStr[1] = ' ') do Delete(NStr,1,1);
                  TempSrc.Add('  KeyListe.Add('+Chr(39)+NStr+Chr(39)+');');
                end;
              end;
            end;
          end; {17}
      18: Insert(TypDateiName, S, x1Pos);
    end; {CASE CODENR}
  end;

  Procedure Auswerten(S: String);
  var xStr: String;
      x1Pos, x2Pos, CodeNr, Code: Integer;
      PS  : Array[0..255] of Char;
  begin
    xStr:= S;
    CodeNr:= 0;
    x1Pos:= Pos('%',xStr);
    if x1Pos > 0 then begin
      While x1Pos > 0 do begin
        Delete(xStr,1,x1Pos);
        x2Pos:= Pos('%',xStr);
        if x2Pos > 0 then begin
          xStr:= Copy(xStr,1,x2Pos-1);
          Val(xStr,CodeNr,Code);
        end;
        if CodeNr > 0 then Einfuegen(S,CodeNr,x1Pos);
        xStr:= S;
        CodeNr:= 0;
        x1Pos:= Pos('%',xStr);
      end;
    end;
    if S <> '*' then begin
      TempSrc.Add(S);
    end;
  end;

begin  {Erzeuge_EditorSource}
  Exp:= TIsamMainForm(Parent);
  RecordName:= '';
  MemoName:= '';
  BroIdent:= Exp.Edit3.Text;
  StruIdent:= Exp.DBStruEdit.Text;
  AliasIdent:= Exp.AliasEdit.Text;
  if Exp.RecList.Count > 0 then begin
    For r:= 0 to Exp.RecList.Count - 1 do begin
      RStr:= Uppercase(Exp.RecList[r]);
      Strip(RStr);
      if Pos('=RECORD',RStr) > 0 then RecordName:= Copy(RStr,1,Pos('=RECORD',RStr)-1);
      G:= GetFieldTypEditor(RStr,FeldName,FieldDataType,Len,Arr1,Arr2,Decimals);
      if G = 3 then MemoName:= FeldName;
    end;
  end;
  CommentIgnorieren:= False;
  Ignorieren:= False;
  Impl:= False;
  TempSrc:= TStringList.Create;
  SrcCode:= TStringList.Create;
  SrcCode.LoadFromFile(ProtoName);
  if SrcCode.Count = 0 then MessageDlg(ProtoName+' konnte nicht geladen werden', mtError, [mbOk], 0)
  else begin
    Zeile:= 0;
    Repeat
      SStr:= SrcCode[Zeile];
      GStr:= UpperCase(SStr);
      if Pos('IMPLEMENTATION',GStr) > 0 then Impl:= True;
      if Pos('(*****',GStr) > 0 then CommentIgnorieren:= True;
      (*if (Impl) and (OrigPas <> '')
      and (CommentIgnorieren = False) then begin
      {neu, damit nur die selektierten Procs upgedatet werden}
        if ((Pos('FUNCTION',GStr) > 0) or (Pos('PROCEDURE',GStr) > 0)) then begin
          Idx:= Exp.Listbox2.Items.IndexOf(GetProcName(GStr));
          Errorwindow(GetProcName(GStr),DezStr(idx));
          if (Idx < 0) or (Exp.Listbox2.Selected[idx] = False) then Ignorieren:= True
          else Ignorieren:= False;
        end;
      end;*)
      if (CommentIgnorieren = False) and (Ignorieren = False) then Auswerten(SStr);
      if Pos('*****)',GStr) > 0 then CommentIgnorieren:= False;
      if Pos('END.',GStr) > 0 then Impl:= False;
      Inc(Zeile);
    Until Zeile = SrcCode.Count;
    if OrigPas <> '' then begin
      if Exp.EdiProcUpdcheck.Checked then Proc_Update(TempSrc,OrigPas,Exp.Listbox2)
      else AltSource_Verwerten(TempSrc,OrigPas,Exp.CodeTable);
    end;
    SourceBuffer := StrAlloc(SourceBufferSize);
    try
      Result := TMemoryStream.Create;
      try
        if TempSrc.Count > 0 then begin
          For r:= 0 to TempSrc.Count-1 do begin
            SStr:= TempSrc[r];
            Strpcopy(Ps,SStr+CRLF);
            FmtWrite(Result,PS,[NIL]);
          end;
        end;
        Result.Position := 0;
      except
        Result.Free;
        raise;
      end;
    finally
    StrDispose(SourceBuffer);
    end;
  end;
  TempSrc.Free;
  SrcCode.Free;
end;

end.
